/*******************************************************************************
 * BubbleSort.java
 *
 * Kara sortiert ein "Balkendiagramm" von Kleeblttern (vertikal angeordnet) mit
 * dem Bubblesort-Algorithmus. Damit das Programm einfach und auch
 * gengend schnell ist, greift es direkt auf das world-Objekt zu.
 * Daher muss wieder die Methode tools.checkState() aufgerufen werden,
 * damit die Ausfhrung des Programms von aussen kontrolliert werden kann.
 *
 ******************************************************************************/
import JavaKaraProgram;

public class BubbleSort extends JavaKaraProgram {

  int getNumber(int y) {
    int length = 0;
    for (int x = 0; x < world.getSizeX(); x++) {
      if (world.isLeaf (x, y)) {
        length++;
      }
    }
    return length;
  }


  void showNumbers (int[] numbers) {
    for (int y = 0; y < world.getSizeY(); y++) {
      for (int x = 0; x < world.getSizeX(); x++) {
        world.setLeaf (x, y, (x < numbers[y]));
      }
    }
    tools.checkState();
  }


  void permutateNumbers (int[] numbers) {
    for (int y = 0; y < world.getSizeY(); y++) {
      numbers[y] = y;
    }
    for (int i = 0; i < world.getSizeY()*10; i++) {
      int u = tools.random (numbers.length-1);
      int v = tools.random (numbers.length-1);
      swap (numbers, u, v);
    }
  }


  void swap (int[] numbers, int index1, int index2) {
    int temp        = numbers[index1];
    numbers[index1] = numbers[index2];
    numbers[index2] = temp;
  }


  public void myProgram() {
    int[] numbers = new int[world.getSizeY()];
    boolean numbersSorted = false;

    // wenn die Welt zu Beginn ein Balkendiagramm enthlt:
    for (int y = 0; y < world.getSizeY(); y++) {
      numbers[y] = getNumber(y);
    }

    // sonst kann man auch eines erstellen lassen:
    // permutateNumbers(numbers);

    while (!numbersSorted) {
      numbersSorted = true;
      for (int i = 0; i < numbers.length-1; i++) {
        if (numbers[i] > numbers[i+1]) {
          swap (numbers, i, i+1);
          numbersSorted = false;
          showNumbers (numbers);
        }
      }
    }
  }

}
