/*******************************************************************************
 * GameOfLife.java
 *
 * Kara schaut dem "Spiel des Lebens" zu. Damit das Programm einfacher wird,
 * greift das Programm direkt auf den "Speicher" der Welt zu. Dafr stehen
 * einige Methoden des Objekts world zur Verfgung (siehe
 * unten). Zudem muss regelmssig die Methode tools.checkState()
 * aufgerufen werden. Diese Methode schaut auf den Geschwindigkeitsregler
 * im JavaKara-Hauptprogramm und legt das Programm eine entsprechende
 * Zeitdauer schlafen.
 *
 ******************************************************************************/
import JavaKaraProgram;

public class GameOfLife extends JavaKaraProgram {

  boolean cells[][];
  boolean newCells[][];

  int countNeighborsIncl (int y, int x) {
    int count = 0;
    for (int i = y-1; i <= y+1; i++) {
      for (int j= x-1; j <= x+1; j++) {
        if (cells[i][j]) {
          count++;
        }
      }
    }
    return count;
  }

  boolean newCellValue (int y, int x) {
    int neighbors = countNeighborsIncl (y, x);
    if (cells[y][x]) {
      neighbors = neighbors-1; // Zelle selbst zhlt nicht
      return (neighbors == 2) || (neighbors == 3);
    }
    else {
      return (neighbors == 3);
    }
  }

  public void myProgram() {
    final int SIZE_X = world.getSizeX();
    final int SIZE_Y = world.getSizeY();
    cells    = new boolean[SIZE_Y][SIZE_X];
    newCells = new boolean[SIZE_Y][SIZE_X];
    int x, y;

    // mit dem folgenden Code kann die Welt zufllig
    // initialisiert werden

    /* for (y = 1; y < SIZE_Y-1; y++) {
      for (x = 1; x < SIZE_X-1; x++) {
        int r = tools.random(1);
        world.setLeaf (x, y, r == 1);
      }
    }
    tools.checkState();
  */

    for (y = 1; y < SIZE_Y-1; y++) {
      for (x = 1; x < SIZE_X-1; x++) {
        cells[y][x] = world.isLeaf (x, y);
      }
    }

    while (true) {
      for (y = 1; y < SIZE_Y-1; y++) {
        for (x = 1; x < SIZE_X-1; x++) {
          newCells[y][x] = newCellValue (y, x);
        }
      }

      for (y = 1; y < SIZE_Y-1; y++) {
        for (x = 1; x < SIZE_X-1; x++) {
          cells[y][x] = newCells[y][x];
          world.setLeaf (x, y, cells[y][x]);
        }

      }
      tools.checkState();
    }
  }

}

