/*******************************************************************************
 * InvertImage.java
 *
 * Kara "invertiert" ein Kleeblatt-Bild.
 ******************************************************************************/
import JavaKaraProgram;

public class InvertImage extends JavaKaraProgram {

  void invert() {
    if (kara.onLeaf())
 {
      kara.removeLeaf();
    }
    else
 {
      kara.putLeaf();
    }
  } 

  void walk() {
    invert();
    while (!kara.treeFront()) {
      kara.move();
      invert();
    }
  } 

  void left2right() {
    walk();
    if (!kara.treeRight()) {
      kara.turnRight();
      kara.move();
      kara.turnRight();
    }
  }

  void right2left() {
    walk();
    if (!kara.treeLeft()) {
      kara.turnLeft();
      kara.move();
      kara.turnLeft();
    }
  }


  public void myProgram() {
    boolean walkingLeft2Right = true;

    while (!( kara.treeFront() && 
              (kara.treeLeft() || kara.treeRight()) )) {
      if (walkingLeft2Right)
 {
        left2right();
      }
      else
 {
        right2left();
      }
      walkingLeft2Right = !walkingLeft2Right;
    }
  }

}
