/*******************************************************************************
 * LevelLabyrinth.java
 *
 * Kara sucht das Kleeblatt, das beim Ausgang eines Labyrinths liegt.
 *
 * Diese Lsung lsst kein Loch aus. Das Programm benutzt zwei
 * boolean-Variablen, um sich zu merken, ob es nach einem
 * bergang in die nchste "Zeile" des Labyrinths in Loch
 * zur Linken oder zur Rechten ignorieren muss. Sonst besteht
 * Gefahr, dass das Programm endlos das gleiche Loch rauf- und
 * runterluft.
 ******************************************************************************/
import JavaKaraProgram;

public class LevelLabyrinth2 extends JavaKaraProgram {

  public void myProgram() {
    boolean ignoriereLochLinks = false;
    boolean ignoriereLochRechts= true;

    while (!kara.onLeaf()) {
      while ((ignoriereLochLinks || kara.treeLeft()) &&
             (ignoriereLochRechts || kara.treeRight())) {
        if (!kara.treeFront()) {
          kara.move();
        }
        else {
          ignoriereLochLinks = !ignoriereLochLinks;
          ignoriereLochRechts= !ignoriereLochRechts;
          kara.turnLeft();
          kara.turnLeft();
        }
      }
      if (!ignoriereLochLinks && !kara.treeLeft()) {
        ignoriereLochLinks = true;
        ignoriereLochRechts= false;
        kara.turnLeft();
        kara.move();
        kara.move();
        kara.turnLeft();
      }
      else {
        ignoriereLochLinks = false;
        ignoriereLochRechts= true;
        kara.turnRight();
        kara.move();
        kara.move();
        kara.turnRight();
      }
    }
    kara.removeLeaf();
  }

}

